unit Unit1;

//        
//  TListBox.      
// onDrawItem,    Style  TListBox.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    ComboBox2: TComboBox;
    Label3: TLabel;
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ComboBox1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ComboBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//    ,    TListBox
//  Canvas,    Style,   
//   lbOwnerDrawFixed  lbOwnerDrawVariable.

var PicStyle : byte;  //    ( )

procedure TForm1.ListBox1DrawItem(Control: TWinControl; Index: Integer;
                                  Rect: TRect; State: TOwnerDrawState);
const PicLen   = 20;              //    
      Delim    = 5;               //   
      Pos1     = PicLen + Delim;  //     
      Pos2     = 2 * Pos1;        //     
begin
  if Control is TListBox
  then begin
    with (Control as TListBox) do
    begin
      Canvas.Pen.Style := psClear;
      case PicStyle of
      0 : begin  //  
            //    
            Canvas.Brush.Style := bsSolid;
            Canvas.Brush.Color := Color;
            Canvas.Rectangle(Rect.Left, Rect.Top,
                             Rect.Right, Rect.Bottom);
            //  
            //    .
            Canvas.Brush.Color := clBlue;
            //    
            //  integer  TBrushStyle
            Canvas.Brush.Style := TBrushStyle(Index mod 8);
            Canvas.Rectangle(Rect.Left, Rect.Top + 1,
                             Rect.Left + PicLen, Rect.Bottom -1 );
            //     
            if Selected[Index]
            then Canvas.Font.Color := clRed
            else Canvas.Font.Color := clBlack;
            Canvas.Brush.Style := bsClear;
            Canvas.TextOut(Rect.Left + Pos1, Rect.Top,
                          IntToStr(Index) + '. ' + Items.Strings[Index]);
          end;
      1 : begin //    
            //    
            Canvas.Brush.Style := bsSolid;
            Canvas.Brush.Color := Color;
            Canvas.Rectangle(Rect.Left, Rect.Top,
                             Rect.Right, Rect.Bottom);
            //    
            Canvas.Brush.Color := clBtnFace;
            Canvas.Rectangle(Rect.Left, Rect.Top + 1,
                             Rect.Left + PicLen, Rect.Bottom -1 );
            Canvas.Brush.Style := bsClear;
            Canvas.TextOut(Rect.Left + Delim, Rect.Top, IntToStr(Index));
            //       
            if Selected[Index]
            then begin
               //   
               //    
               Canvas.Brush.Style := bsSolid;
               //     
               //  integer  TColor
               Canvas.Brush.Color := TColor(Random(32767));
               Canvas.Ellipse(Rect.Left + Pos1, Rect.Top + 1,
                              Rect.Left + Pos1 + 2 * Delim, Rect.Bottom -1 );
               //  
               Canvas.Brush.Style := bsClear;
               Canvas.Font.Color := clBlue;
               Canvas.TextOut(Rect.Left + Pos2, Rect.Top,
                             Items.Strings[Index]);
            end
            else begin
               //   
               Canvas.Font.Color := clBlack;
               Canvas.Brush.Style := bsClear;
               Canvas.TextOut(Rect.Left + Pos2, Rect.Top,
                             Items.Strings[Index]);
            end;
          end;
      end; // of case PicStyle
    end;  // of with (Control as TListBox)
  end; // of if Control is TListBox
end;

procedure TForm1.ComboBox1Click(Sender: TObject);
begin
   case ComboBox1.ItemIndex of
    0 : ListBox1.Style := lbStandard;
    1 : ListBox1.Style := lbOwnerDrawFixed;
    2 : ListBox1.Style := lbOwnerDrawVariable;
   end;
   ListBox1.Repaint;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
   ListBox1.Repaint;
end;

procedure TForm1.ComboBox2Click(Sender: TObject);
begin
   PicStyle := ComboBox2.ItemIndex;
   ListBox1.Repaint;
end;

end.

